local c;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local t = Def.ActorFrame {
	LoadFont( "Combo", "numbers" ) .. {
		Name="Number";
		OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
	};
	LoadActor("_combo") .. {
		Name="ComboLabel"; 
        InitCommand=cmd(y,64);
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
	LoadActor("_misses") .. {
		Name="MissesLabel";
        InitCommand = cmd(diffuse,1,0,0,1;y,64);
		OnCommand = THEME:GetMetric("Combo", "LabelOnCommand");
	};
    LoadActor( THEME:GetPathS("Player", "annoy") ) .. {
        Name="Annoy";
    };
	InitCommand = function(self)
		c = self:GetChildren();
		c.Number:visible(false);
		c.ComboLabel:visible(false);
		c.MissesLabel:visible(false);
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			c.Number:visible(false);
			c.ComboLabel:visible(false);
			c.MissesLabel:visible(false);
			return;
		end
        
		local Label;
		if param.Combo then
			Label = c.ComboLabel;
		else
			Label = c.MissesLabel;
		end
		-- reset the label's visibility so we don't accidentally draw both labels
		Label:visible(false);

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		c.Number:visible(true);
		Label:visible(true);

--[[         if not param.FullComboW1 or param.FullComboW2 or param.FullComboW3 then
            c.Number:stopeffect();
            c.Label:stopeffect();
        end; --]]
        
        c.Number:settext(string.format('%03i', iCombo));
        
        if param.FullComboW1 then
            c.Number:diffuseshift();
            c.Number:effectcolor1(color("#FFCC00"));
            c.ComboLabel:diffuseshift();
            c.ComboLabel:effectcolor1(color("#FFCC00"));
        end;
        if param.FullComboW2 then
            c.Number:diffuseshift();
            c.Number:effectcolor1(color("#00C6FF"));
            c.ComboLabel:diffuseshift();
            c.ComboLabel:effectcolor1(color("#00C6FF"));
        end;
        if param.FullComboW3 then
            c.Number:diffuseshift();
            c.Number:effectcolor1(color("#00E000"));
            c.ComboLabel:diffuseshift();
            c.ComboLabel:effectcolor1(color("#00E000"));
        end;
        
		Pulse( c.Number, param );
		Pulse( Label, param );
        
--[[         if param.Combo % 10 == 0 then
--~             Annoy:playforplayer(player);
            SOUND:PlayOnce( THEME:GetPathS("Player", "annoy") );
        end; --]]
        
            
	end;
};

return t;
